/*
 
 Copyright (c) 2004 PXI Project Team
 
 Permission is hereby granted, free of charge, to any person obtaining a copy of
 this software and associated documentation files (the "Software"), to deal in the
 Software without restriction, including without limitation the rights to use,
 copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the
 Software, and to permit persons to whom the Software is furnished to do so,
 subject to the following conditions:
 
 The above copyright notice and this permission notice shall be included in all copies
 or substantial portions of the Software.
 
 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 
 */

//  PXIFieldView.m
//  PXIView
//
//  last changed by: creysoft

#import "PXIFieldView.h"

extern PXIMasterController * gPXIWorld;

@implementation PXIFieldView

+ (float)scrollerWidth
{
	return 17;
}

- (id)initWithFrame:(NSRect)frame {
    self = [super initWithFrame:frame];
    if (self) {
        // Initialization code here.
		myTextField = [[PXICleanTextView alloc] initWithFrame:NSMakeRect( 1, 1, frame.size.width - 2, frame.size.height - 2)];
		myScroller = [[PXICustomScroller alloc] init];
		rndcorners = [NSImage imageNamed: @"rndcrn"];
		//[myTextField insertText:@"Man, this sucks."];
		[myTextField setDrawsBackground:NO];
		[self setLineWrap:YES];
		[self addSubview:myTextField];

		[self setPartStyle:PXIPartStyleTransparent];
   }
    return self;
}

- (BOOL)lineWrap {
    return lineWrap;
}

- (void)setLineWrap:(BOOL)newLinewrap {
	NSSize theSize;
    if (lineWrap != newLinewrap) {
        lineWrap = newLinewrap;
		
		if ( newLinewrap == NO )
		{
			theSize = [[myTextField textContainer] containerSize];
			theSize.width = 1.0e7;
			[[myTextField textContainer]  setContainerSize:theSize];
			[[myTextField textContainer]  setWidthTracksTextView:NO];
		}
		else
		{
			theSize = [[myTextField textContainer]  containerSize];
			theSize.width = [self frame].size.width;
			[[myTextField textContainer]  setContainerSize:theSize];
			[[myTextField textContainer]  setWidthTracksTextView:YES];			
		}
		
    }
}

- (BOOL)enabled {
    return enabled;
}

- (void)setEnabled:(BOOL)newEnabled {
    if (enabled != newEnabled) {
        enabled = newEnabled;
    }
}

- (BOOL)visible {
    return visible;
}

- (void)setVisible:(BOOL)newVisible {
    if (visible != newVisible) {
        visible = newVisible;
    }
}

- (int)partStyle {
    return partStyle;
}

- (void)setPartStyle:(int)newPartstyle {
    if (partStyle != newPartstyle) {
		
		if ( ( partStyle == PXIPartStyleScrolling ) && ( newPartstyle != PXIPartStyleScrolling ) )
		{
			// If we're going from a scrollview to a flat
			// field, we've gotta unload the scroll view
			// and put the text field back.
			
			[myScrollView removeFromSuperview];
			[self addSubview:myTextField];
			[myTextField setFrame:NSMakeRect( 1, 1, [self frame].size.width - 2, [self frame].size.height - 2)];

			partStyle = newPartstyle;
			
			[self setNeedsDisplay:YES];
		}
		else
		{
			partStyle = newPartstyle;
				 
			if ( newPartstyle == PXIPartStyleScrolling )
			{
				// If we've got a scrollview, we've gotta unload the entire
				// view and rebuild it.
				
				[myTextField retain];
				[myTextField setFrame:NSMakeRect( 1, 1, [self frame].size.width - 19, [self frame].size.height - 2)];
				myScrollView = [[PXICustomScrollView alloc] initWithFrame:NSMakeRect( 0, 0, [self frame].size.width, [self frame].size.height )];

				[myScrollView setVerticalScroller:(NSScroller*)myScroller];
				[myScrollView setBorderType:NSLineBorder];

				[myScrollView setHasVerticalScroller:YES];
				[myScrollView setAutohidesScrollers:NO];
				[myScrollView setHasHorizontalScroller:NO];
				
				[myTextField removeFromSuperview];
				[self addSubview:myScrollView];

				[myScrollView setDocumentView:myTextField];
			}
		}
    }
}

- (NSString *)partName {
    return [[partName retain] autorelease];
}

- (void)setPartName:(NSString *)newPartname {
    if (partName != newPartname) {
        [partName release];
        partName = [newPartname copy];
    }
}

- (NSString *)value
{
	return [myTextField string];
}

- (void)setValue:(NSString *)newValue
{
	[myTextField setString:newValue];
}

- (NSFont *)font
{
	return [myTextField font];
}

- (void)setFont:(NSFont *)whatFont
{
	[myTextField setFont:whatFont];
}

- (int)textSize
{
	return textSize;
}

- (void)setTextSize:(int)newTextSize
{
	textSize = newTextSize;
	[myTextField setFont:[NSFont fontWithName:[[self font] fontName] size:newTextSize]];
}

- (void)drawRect:(NSRect)rect {
    // Drawing code here.
	[super drawRect:rect];
	NSRect trueRect = NSMakeRect( 0.5, 0.5, [super frame].size.width - 1, [super frame].size.height -1 );

	[[NSGraphicsContext currentContext] setShouldAntialias:NO];
	
	switch ( [self partStyle] )
	{
		case PXIPartStyleOpaque:
			[[NSColor whiteColor] set];
			[NSBezierPath fillRect:trueRect];
			break;			
		case PXIPartStyleRectangle:
			[[NSColor whiteColor] set];
			[NSBezierPath fillRect:trueRect];
			[[NSColor blackColor] set];
			[NSBezierPath strokeRect:trueRect];
			break;
		case PXIPartStyleShadow:
			[[NSColor blackColor] set];
			[NSBezierPath fillRect:NSMakeRect( trueRect.origin.x + 2, trueRect.origin.y, trueRect.size.width - 2, trueRect.size.height - 2)];
			[[NSColor whiteColor] set];
			[NSBezierPath fillRect:NSMakeRect( trueRect.origin.x, trueRect.origin.y + 1, trueRect.size.width - 2, trueRect.size.height - 2)];
			[[NSColor blackColor] set];
			[NSBezierPath strokeRect:NSMakeRect( trueRect.origin.x, trueRect.origin.y + 1, trueRect.size.width - 2, trueRect.size.height - 2)];			
			break;
		case PXIPartStyleScrolling:
			//[[NSColor whiteColor] set];
			//[NSBezierPath fillRect:trueRect];
			[[NSColor blackColor] set];
			[NSBezierPath strokeRect:trueRect];
			break;			
		case PXIPartStyleRoundRect:
			// Draw opaque interior.
			[[NSColor whiteColor] set];
			[NSBezierPath fillRect:NSMakeRect( trueRect.origin.x + 7, trueRect.origin.y, trueRect.size.width - 14, trueRect.size.height ) ];
			[NSBezierPath fillRect:NSMakeRect( trueRect.origin.x, trueRect.origin.y + 7, trueRect.size.width, trueRect.size.height - 14 ) ];
			
			[[NSColor blackColor] set];
			
			// Draw corners
			[rndcorners compositeToPoint:NSMakePoint( 0, 0 ) fromRect:NSMakeRect( 0, 0, 7, 7 ) operation:NSCompositeSourceOver];
			[rndcorners compositeToPoint:NSMakePoint( 0, trueRect.origin.y + trueRect.size.height - 7 ) fromRect:NSMakeRect( 0, 7, 7, 7 ) operation:NSCompositeSourceOver];
			[rndcorners compositeToPoint:NSMakePoint( trueRect.origin.x + trueRect.size.width - 7, 0 ) fromRect:NSMakeRect( 7, 0, 7, 7 ) operation:NSCompositeSourceOver];
			[rndcorners compositeToPoint:NSMakePoint( trueRect.origin.x + trueRect.size.width - 7, trueRect.origin.y + trueRect.size.height - 7 ) fromRect:NSMakeRect( 7, 7, 7, 7 ) operation:NSCompositeSourceOver];
			
			// Draw Outline
			[NSBezierPath setDefaultLineWidth:1];
			[NSBezierPath strokeLineFromPoint:NSMakePoint( 7.5, trueRect.origin.y + trueRect.size.height - 0.5 ) toPoint:NSMakePoint( trueRect.origin.x + trueRect.size.width - 7.5, trueRect.origin.y + trueRect.size.height - 0.5  ) ];

			[NSBezierPath setDefaultLineWidth:2];
			[NSBezierPath strokeLineFromPoint:NSMakePoint( trueRect.origin.x + trueRect.size.width - 0.5, 7.5 ) toPoint:NSMakePoint( trueRect.origin.x + trueRect.size.width - 0.5, trueRect.origin.y + trueRect.size.height - 7.5  ) ];
			[NSBezierPath strokeLineFromPoint:NSMakePoint( 7.5, 0.5 ) toPoint:NSMakePoint( trueRect.origin.x + trueRect.size.width - 7.5, 0.5 ) ];

			[NSBezierPath setDefaultLineWidth:1];			
			[NSBezierPath strokeLineFromPoint:NSMakePoint( 0.5, 7.5 ) toPoint:NSMakePoint( 0.5, rect.origin.y + trueRect.size.height - 7.5 ) ];			
			break;
	}
	
	if ( [ gPXIWorld currentTool ] == 2 )
	{
		[[NSColor blackColor] set];
		[NSBezierPath strokeRect:trueRect];
		NSLog( @"Strokin' it!" );
	}
}

- (void) mouseDown:(NSEvent*)theEvent
{
	NSLog( @"%@ : mouseDown", [self partName]);
	
	NSPoint fudgeFactor = [self convertPoint:[[self window] mouseLocationOutsideOfEventStream] fromView:nil];
	
	while ( [[self window] nextEventMatchingMask:NSLeftMouseUpMask untilDate:nil inMode:NSEventTrackingRunLoopMode dequeue:YES] == nil )
	{
		
		if ( [gPXIWorld currentTool] == 2 )
		{
		
			NSPoint newLocation = [[self window] mouseLocationOutsideOfEventStream];
			
			[self setFrame:NSMakeRect( newLocation.x - fudgeFactor.x, newLocation.y - fudgeFactor.y, [self frame].size.width, [self frame].size.height )];
			[self display];
			
		}
		
		NSLog( @"%@ : mouseStillDown", [self partName]);
	}
	
	NSLog( @"%@ : mouseUp", [self partName]);
}

- (void) mouseUp:(NSEvent*)theEvent
{
	NSLog( @"%@ : mouseUp", [self partName]);
}

- (void) mouseEntered:(NSEvent*)theEvent
{
	NSLog( @"%@ : mouseEnter", [self partName]);
}

- (void) mouseExited:(NSEvent*)theEvent
{
	NSLog( @"%@ : mouseLeave", [self partName]);
}

- (void)dealloc
{
	[super dealloc];
	[myScroller release];
	[myTextField release];
	[rndcorners release];
	//[partName release];
}

@end
